/*
  Copyright (c) 2010 nosuke <sasugaanija@gmail.com>

  All rights reserved.

  Redistribution and use in source and binary forms, with or
  without modification, are permitted provided that the
  following conditions are met:

  1. Redistributions of source code must retain the above
     copyright notice, this list of conditions and the
     following disclaimer.
  2. Redistributions in binary form must reproduce the above
     copyright notice, this list of conditions and the
     following disclaimer in the documentation and/or other
     materials provided with the distribution.
  3. Neither the name of authors nor the names of its
     contributors may be used to endorse or promote products
     derived from this software without specific prior written
     permission.

  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
  CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
  INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
  DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
  CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
  LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
  HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
  CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
  OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

#include <stdio.h>
#include <spu_intrinsics.h>
#include <spu_mfcio.h>
#include <spurs/spsa/spsa.h>

#define HOST_NUM 4
#define SPE_NUM 4

static spsa_object_t bmp1, bmp2;

// åݡȤ2ĻȤäХꥢƱ (Ȥνϥۥ¦ȤޤäƱ)
void
barrier(void)
{
    uint32_t size, seq, dat;

    size = sizeof(dat);
    spsa_wait_message_port(bmp1, SP3_MPORT_WAIT_NEXT_SEQ, 0,
                           SP3_TIMEOUT_INDEFINITE, &seq, &dat, &size);

    spsa_signal_message_port(bmp1, SP3_MPORT_SIGNAL_ASYNC, 0, &dat, sizeof(dat),
                             &seq);

    if (seq == SPE_NUM + HOST_NUM + 1) {
        spsa_signal_message_port(bmp1, SP3_MPORT_SIGNAL_UPDATE, 0, &dat,
                                 sizeof(dat), &seq);
        
        spsa_signal_message_port(bmp2, SP3_MPORT_SIGNAL_UPDATE, 1, &dat,
                                 sizeof(dat), &seq);
    }

    size = sizeof(dat);
    spsa_wait_message_port(bmp2, SP3_MPORT_WAIT_NEXT_SEQ, 0,
                           SP3_TIMEOUT_INDEFINITE, &seq, &dat, &size);
    
    spsa_signal_message_port(bmp2, SP3_MPORT_SIGNAL_ASYNC, 0, &dat, sizeof(dat),
                             &seq);

    if (seq == SPE_NUM + HOST_NUM + 1) {
        spsa_signal_message_port(bmp2, SP3_MPORT_SIGNAL_UPDATE, 0, &dat,
                                 sizeof(dat), &seq);

        spsa_signal_message_port(bmp1, SP3_MPORT_SIGNAL_UPDATE, 1, &dat,
                                 sizeof(dat), &seq);
    }
}

int
main(uint32_t arg0, uint32_t arg1)
{
    int i, id;
    spsa_object_t csem;
    uint8_t buf[128] __attribute__((aligned(16)));
    spsa_object_t arg_mq;
    uint32_t size;
    uint32_t shmem_ea;

    id = arg0;
    arg_mq = arg1;

    // å塼̤ƻȤEA
    size = sizeof(spsa_status_t);
    spsa_wait_message_queue(arg_mq, SP3_TIMEOUT_INDEFINITE, &bmp1, &size);
    size = sizeof(spsa_status_t);
    spsa_wait_message_queue(arg_mq, SP3_TIMEOUT_INDEFINITE, &bmp2, &size);
    size = sizeof(uint32_t);
    spsa_wait_message_queue(arg_mq, SP3_TIMEOUT_INDEFINITE, &shmem_ea, &size);
    size = sizeof(spsa_status_t);
    spsa_wait_message_queue(arg_mq, SP3_TIMEOUT_INDEFINITE, &csem, &size);

    // ǽ˥ХꥢƱ (ۥȤޤ)
    barrier();

    for (i = 0; i < 1000; i++) {
        // ޥե
        spsa_wait_semaphore(csem, SP3_TIMEOUT_INDEFINITE);

        // DMAžɤ߽Ф
        spu_mfcdma64(buf, 0, shmem_ea, sizeof(buf), 0, MFC_GET_CMD);
        spu_writech(MFC_WrTagMask, 1 << 0);
        spu_mfcstat(MFC_TAG_UPDATE_ALL);

        // 󥿤䤹
        *(uint32_t *)buf = *(uint32_t *)buf + 1;

        // DMAžǽᤷ
        spu_mfcdma64(buf, 0, shmem_ea, sizeof(buf), 0, MFC_PUT_CMD);
        spu_writech(MFC_WrTagMask, 1 << 0);
        spu_mfcstat(MFC_TAG_UPDATE_ALL);

        // ޥե
        spsa_signal_semaphore(csem);
    }

    // Ǹ˥ХꥢƱ (ۥȤޤ)
    barrier();

    return 0;
}
