/*
  Copyright (c) 2010 nosuke <sasugaanija@gmail.com>

  All rights reserved.

  Redistribution and use in source and binary forms, with or
  without modification, are permitted provided that the
  following conditions are met:

  1. Redistributions of source code must retain the above
     copyright notice, this list of conditions and the
     following disclaimer.
  2. Redistributions in binary form must reproduce the above
     copyright notice, this list of conditions and the
     following disclaimer in the documentation and/or other
     materials provided with the distribution.
  3. Neither the name of authors nor the names of its
     contributors may be used to endorse or promote products
     derived from this software without specific prior written
     permission.

  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
  CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
  INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
  DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
  CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
  LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
  HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
  CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
  OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <malloc.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <arpa/inet.h>
#include <spurs/spha/spha.h>

// pathǻꤷSPEץɤ߽Ф
void
load_spe_program(const char *path, int32_t *size, uint8_t **buf,
                 uint32_t *buf_len)
{
    struct stat prog_stat;
    FILE *fp = fopen(path, "r");
    stat(path, &prog_stat);
    // ǥžΤ128Byte饤128ܿ
    *size = prog_stat.st_size;
    *buf_len = (*size + 127) & ~127;
    *buf = memalign(128, *buf_len);
    fread(*buf, 1, *size, fp);
    fclose(fp);
}

int
main()
{
    int i;
    int32_t spe_prog_file_size;  // ELFΥ
    uint8_t *spe_prog_buf;       // ELFɤ߽ФХåե
    uint32_t spe_prog_buf_size;  // ELFɤ߽ФХåե
    spha_session_t session;      // å
    spha_thread_t spha_thread;   // SPEå
    spha_object_t spe_prog_mem;  // ELFžΥ֥
    uint32_t spe_program_ea;     // ELFŽդEA
    uint32_t loader_args[3];     // ELFϤ
    uint32_t call_args[32];      // SPEåɤϤ

    // SPE_PROGRAM_FILEɤ
    load_spe_program("hello_spe", &spe_prog_file_size, &spe_prog_buf,
                     &spe_prog_buf_size);

    // åĥ
    spha_create_session(NULL, &session);
    spha_connect_session(session);

    // SPEץELFŽդΰ
    spha_create_memory(session, 0, 0, 0, spe_prog_buf_size, 0, &spe_prog_mem);

    // ΰELFž
    spha_data_transfer_to(session, spe_prog_mem, 0, spe_prog_buf,
                          &spe_prog_buf_size);
    free(spe_prog_buf);

    // ΰEA֤˥ޥåפ
    spha_map_memory(session, spe_prog_mem, 0, 0, 0, spe_prog_file_size, 0,
                    &spe_program_ea);

    // åΰ
    loader_args[0] = htonl(spe_program_ea);      // SPEץELFEA
    loader_args[1] = htonl(spe_prog_file_size);  // ELFΥ
    loader_args[2] = 0;                          // 0

    // SPEELFꤷSPEåɤ
    spha_create_spe_thread(session, 0, NULL, SP3_SPE_LOADER_DEFAULT,
                           loader_args, sizeof(loader_args), &spha_thread);

    // mainΰ (ǤƬ48ByteΤ߻)
    for (i = 0; i < 32 / sizeof(uint32_t); i++)
        call_args[i] = htonl(1000 + i);

    for (i = 32 / sizeof(uint32_t); i < 48 / sizeof(uint32_t); i++)
        call_args[i] = 1000 + i; // տŪ˥ȥ륨ǥΤޤޤ

    // SPEåɤΥ֥å󥰼¹
    spha_resume_spe_thread(session, spha_thread, 0,
                           SP3_SPE_THREAD_RESUME_DEFAULT_ENTRY, call_args,
                           sizeof(call_args), NULL, NULL, NULL);

    // SPEåɤߡλԤ
    spha_wait_spe_thread(session, spha_thread, NULL, NULL, NULL);

    // SPEåɤ˴
    spha_delete_spe_thread(session, spha_thread);

    // åǤ˴
    spha_close_session(session);
    spha_delete_session(session);

    return 0;
}
