/*
  Copyright (c) 2010 nosuke <sasugaanija@gmail.com>

  All rights reserved.

  Redistribution and use in source and binary forms, with or
  without modification, are permitted provided that the
  following conditions are met:

  1. Redistributions of source code must retain the above
     copyright notice, this list of conditions and the
     following disclaimer.
  2. Redistributions in binary form must reproduce the above
     copyright notice, this list of conditions and the
     following disclaimer in the documentation and/or other
     materials provided with the distribution.
  3. Neither the name of authors nor the names of its
     contributors may be used to endorse or promote products
     derived from this software without specific prior written
     permission.

  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
  CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
  INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
  DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
  CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
  LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
  HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
  CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
  OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

#include <stdio.h>
#include <spu_mfcio.h>
#include <mars/task.h>

int
mars_task_main(const struct mars_task_args *args)
{
    uint64_t semaphore_ea = args->type.u64[0];
    uint64_t buf_ea = args->type.u64[1];
    uint8_t buf[16] __attribute__((aligned(16)));
    int i;


    for (i = 0; i < 1000; i++) {
        // ޥե
        mars_task_semaphore_acquire(semaphore_ea);

        // ǤDMAǶͭѿɤ߽Ф
        spu_writech(MFC_WrTagMask, 1);
        spu_mfcdma64(buf, (uint32_t)(buf_ea >> 32), (uint32_t)buf_ea,
                     sizeof(buf), 0, MFC_GET_CMD);
        spu_mfcstat(MFC_TAG_UPDATE_ALL);

        // 1䤷ƽᤷ
        *(int *)buf += 1;

        spu_mfcdma64(buf, (uint32_t)(buf_ea >> 32), (uint32_t)buf_ea,
                     sizeof(buf), 0, MFC_PUT_CMD);
        spu_mfcstat(MFC_TAG_UPDATE_ALL);

        // ޥե
        mars_task_semaphore_release(semaphore_ea);
    }

    return 0;
}

