/*
  Copyright (c) 2010 nosuke <sasugaanija@gmail.com>

  All rights reserved.

  Redistribution and use in source and binary forms, with or
  without modification, are permitted provided that the
  following conditions are met:

  1. Redistributions of source code must retain the above
     copyright notice, this list of conditions and the
     following disclaimer.
  2. Redistributions in binary form must reproduce the above
     copyright notice, this list of conditions and the
     following disclaimer in the documentation and/or other
     materials provided with the distribution.
  3. Neither the name of authors nor the names of its
     contributors may be used to endorse or promote products
     derived from this software without specific prior written
     permission.

  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
  CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
  INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
  DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
  CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
  LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
  HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
  CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
  OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

#include <stdio.h>
#include <spu_mfcio.h>
#include <mars/task.h>

int
mars_task_main(const struct mars_task_args *args)
{
    printf("Hello World #%d\n", args->type.u32[2]);

    if (args->type.u32[2] == 0) {
        uint64_t tasks_ea = args->type.u64[0];
        struct mars_task_id tasks[3] __attribute__((aligned(16)));
        struct mars_task_args subargs;
        int ret;

        // ɤ߽Ф
        spu_writech(MFC_WrTagMask, 1);
        spu_mfcdma64(tasks, (uint32_t)(tasks_ea >> 32), (uint32_t)tasks_ea,
                     sizeof(tasks), 0, MFC_GET_CMD);
        spu_mfcstat(MFC_TAG_UPDATE_ALL);

        // 򥹥塼뤷ƴλԤ
        subargs.type.u32[2] = 2;
        mars_task_schedule(&tasks[2], &subargs, 128);
        mars_task_wait(&tasks[2], &ret);

        subargs.type.u32[2] = 1;
        mars_task_schedule(&tasks[1], &subargs, 128);
        mars_task_wait(&tasks[1], &ret);
    }

    return 0;
}
