/*
  Copyright (c) 2010 nosuke <sasugaanija@gmail.com>

  All rights reserved.

  Redistribution and use in source and binary forms, with or
  without modification, are permitted provided that the
  following conditions are met:

  1. Redistributions of source code must retain the above
     copyright notice, this list of conditions and the
     following disclaimer.
  2. Redistributions in binary form must reproduce the above
     copyright notice, this list of conditions and the
     following disclaimer in the documentation and/or other
     materials provided with the distribution.
  3. Neither the name of authors nor the names of its
     contributors may be used to endorse or promote products
     derived from this software without specific prior written
     permission.

  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
  CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
  INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
  DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
  CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
  LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
  HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
  CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
  OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

#include <stdio.h>
#include <libspe2.h>
#include <mars/task.h>

#define SPE_PROG_FILE "schedmpu_spe"

int
main()
{
    spe_program_handle_t *spe_prog;
    struct mars_context *mars;
    struct mars_task_id tasks[3] __attribute__((aligned(16)));
    struct mars_task_args args;
    int i, ret;

    spe_prog = spe_image_open(SPE_PROG_FILE);

    // MARSƥȤ (ͭƥȡ1ĤSPE)
    mars_context_create(&mars, 1, 0);

    // 3ĺ
    mars_task_create(mars, &tasks[0], "top", spe_prog->elf_image,
                     MARS_TASK_CONTEXT_SAVE_SIZE_MAX);
    mars_task_create(mars, &tasks[1], "sub1", spe_prog->elf_image,
                     MARS_TASK_CONTEXT_SAVE_SIZE_MAX);
    mars_task_create(mars, &tasks[2], "sub2", spe_prog->elf_image,
                     MARS_TASK_CONTEXT_SAVE_SIZE_MAX);

    // 1ܤΥ塼
    args.type.u64[0] = (uint64_t)(uintptr_t)tasks; // EA
    args.type.u32[2] = 0;
    mars_task_schedule(&tasks[0], &args, 128);

    mars_task_wait(&tasks[0], &ret);

    for (i = 0; i < 3; i++)
        mars_task_destroy(&tasks[i]);
    mars_context_destroy(mars);

    spe_image_close(spe_prog);

    return 0;
}
