/*
  Copyright (c) 2010 nosuke <sasugaanija@gmail.com>

  All rights reserved.

  Redistribution and use in source and binary forms, with or
  without modification, are permitted provided that the
  following conditions are met:

  1. Redistributions of source code must retain the above
     copyright notice, this list of conditions and the
     following disclaimer.
  2. Redistributions in binary form must reproduce the above
     copyright notice, this list of conditions and the
     following disclaimer in the documentation and/or other
     materials provided with the distribution.
  3. Neither the name of authors nor the names of its
     contributors may be used to endorse or promote products
     derived from this software without specific prior written
     permission.

  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
  CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
  INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
  DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
  CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
  LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
  HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
  CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
  OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

#include <stdio.h>
#include <stdlib.h>
#include <libspe2.h>
#include <mars/task.h>

#define SPE_PROG_FILE "queue_spe"

int
main()
{
    spe_program_handle_t *spe_prog;
    struct mars_context *mars;
    struct mars_task_id *tasks;
    struct mars_task_args args;
    uint64_t queue_ea_m2h, queue_ea_h2m;
    uint8_t buf[16] __attribute__((aligned(16))); // 塼ɤ߽ѥХåե
    int i;

    spe_prog = spe_image_open(SPE_PROG_FILE);
    mars_context_create(&mars, 0, 0);
    tasks = malloc(sizeof(struct mars_task_id) * 10);

    // 5ǥ16Υ塼 (ۥ)
    mars_task_queue_create(mars, &queue_ea_m2h, 16, 5,
                           MARS_TASK_QUEUE_MPU_TO_HOST);

    // 5ǥ16Υ塼 (ۥȢ)
    mars_task_queue_create(mars, &queue_ea_h2m, 16, 5,
                           MARS_TASK_QUEUE_HOST_TO_MPU);

    for (i = 0; i < 10; i++)
        mars_task_create(mars, &tasks[i], NULL,
                         spe_prog->elf_image, MARS_TASK_CONTEXT_SAVE_SIZE_MAX);

    for (i = 0; i < 10; i++) {
        // 򥹥塼뤹ˡǡ¤EAϤ
        args.type.u64[0] = queue_ea_m2h;
        args.type.u64[1] = queue_ea_h2m;
        mars_task_schedule(&tasks[i], &args, 128);
    }

    for (i = 0; i < 10; i++) {
        // 塼˥ǡͤ
        *(int *)buf = i;
        mars_task_queue_push(queue_ea_h2m, buf);
    }

    for (i = 0; i < 10; i++) {
        // ƥ饭塼˥ǡǼΤԤ
        mars_task_queue_pop(queue_ea_m2h, buf);
        printf("Host: Receive: %d\n", *(int *)buf);
    }

    for (i = 0; i < 10; i++)
        mars_task_wait(&tasks[i], NULL);

    // 塼˴
    mars_task_queue_destroy(queue_ea_m2h);
    mars_task_queue_destroy(queue_ea_h2m);

    for (i = 0; i < 10; i++)
        mars_task_destroy(&tasks[i]);
    free(tasks);
    mars_context_destroy(mars);

    return 0;
}
