/*
  Copyright (c) 2010 nosuke <sasugaanija@gmail.com>

  All rights reserved.

  Redistribution and use in source and binary forms, with or
  without modification, are permitted provided that the
  following conditions are met:

  1. Redistributions of source code must retain the above
     copyright notice, this list of conditions and the
     following disclaimer.
  2. Redistributions in binary form must reproduce the above
     copyright notice, this list of conditions and the
     following disclaimer in the documentation and/or other
     materials provided with the distribution.
  3. Neither the name of authors nor the names of its
     contributors may be used to endorse or promote products
     derived from this software without specific prior written
     permission.

  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
  CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
  INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
  DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
  CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
  LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
  HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
  CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
  OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

#include <stdio.h>
#include <libspe2.h>
#include <mars/task.h>

#define SPE_PROG_FILE "hello_spe"

int
main()
{
    spe_program_handle_t *spe_prog;
    struct mars_context *mars;
    struct mars_task_id task;
    struct mars_task_args args;
    int ret;

    // SPEǼ¹Ԥץե뤫ɤ߹
    spe_prog = spe_image_open(SPE_PROG_FILE);

    // MARSƥȤ (ͭƥȡSPE)
    mars_context_create(&mars, 0, 0);

    // spe_progɤ߹ץ¹Ԥ륿
    // ̾ϡHello Worldס߻ѤХåե (Ȥʤ)
    mars_task_create(mars, &task, "Hello World",
                     spe_prog->elf_image, MARS_TASK_CONTEXT_SAVE_SIZE_MAX);

    // Ϥ
    args.type.u32[0] = 0x01234567;
    args.type.u32[1] = 0xfedcba98;

    // 򥹥塼뤹 (ͥ٤128)
    mars_task_schedule(&task, &args, 128);

    // δλԤ
    mars_task_wait(&task, &ret);
    printf("ret = %d\n", ret);

    // ˴
    mars_task_destroy(&task);

    // MARSƥȤ˴
    mars_context_destroy(mars);

    spe_image_close(spe_prog);

    return 0;
}
