/*
  Copyright (c) 2010 nosuke <sasugaanija@gmail.com>

  All rights reserved.

  Redistribution and use in source and binary forms, with or
  without modification, are permitted provided that the
  following conditions are met:

  1. Redistributions of source code must retain the above
     copyright notice, this list of conditions and the
     following disclaimer.
  2. Redistributions in binary form must reproduce the above
     copyright notice, this list of conditions and the
     following disclaimer in the documentation and/or other
     materials provided with the distribution.
  3. Neither the name of authors nor the names of its
     contributors may be used to endorse or promote products
     derived from this software without specific prior written
     permission.

  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
  CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
  INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
  DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
  CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
  LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
  HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
  CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
  OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

#include <stdio.h>
#include <mars/task.h>

int
mars_task_main(const struct mars_task_args *args)
{
    // ٥ȥե饰ѤΥǡ¤EA
    uint64_t event_flag_ea_m2m = args->type.u64[0];
    uint64_t event_flag_ea_m2h = args->type.u64[1];
    // ˤĤֹ
    int tid = (int)args->type.u32[5];
    uint32_t bits;

    // ʬΥ˳꿶줿IDΥӥåȤΩƤ
    printf("Task: Set (bits: 0x%08x)\n", 1 << tid);
    mars_task_event_flag_set(event_flag_ea_m2m, 1 << tid);

    if (tid == 0) {
        // 0֤ɽԤ
        printf("Task: Wait AND-mode (mask: 0x%08x)\n", (1 << 10) - 1);
        mars_task_event_flag_wait(event_flag_ea_m2m,
                                  (1 << 10) - 1,
                                  MARS_TASK_EVENT_FLAG_MASK_AND, &bits);
        printf("Task: Detected (bits: 0x%08x)\n", bits);
        // ۥ¦ؤΥ٥ȥե饰ΩƤ
        mars_task_event_flag_set(event_flag_ea_m2h, 1);
    }

    return 0;
}

