#include <stdio.h>
#include <string.h>
#include <libspe2.h>

int
test_handler(void *ls_base, unsigned ls_addr)
{
    unsigned arg = *((int *)(ls_base + (ls_addr & ~1)));
    int i, *args;

    args = (int *)(ls_base + (arg & 0x00ffffff));

    for (i = 0; i < 4; i++)
        printf("args[%d] = 0x%08x\n", i, args[i]);

    args[0] = 1;
    args[3] = 0;

    return 0;
}



int
main(int argc, char *argv[])
{ 
    spe_program_handle_t *program;
    unsigned entry = SPE_DEFAULT_ENTRY;
    spe_context_ptr_t context;

    int i;

    // ХåؿꤵƤֹĴ٤Ƥߤ
    for (i = 0; i < 256; i++)
        if (spe_callback_handler_query(i))
            printf("callback %d is already used\n", i);

    // ХåؿϿ
    spe_callback_handler_register(test_handler, 0xff, SPE_CALLBACK_NEW);

    program = spe_image_open("stop_and_signal_spe");

    // SPE_EVENTS_ENABLEɲäʤȼΥХåؿƤ٤ʤ
    context = spe_context_create(SPE_MAP_PS | SPE_EVENTS_ENABLE, NULL); 

    spe_program_load(context, program);
    spe_context_run(context, &entry, 0, NULL, NULL, NULL);

    // SPEΥץबä饳ХåؿϿ
    spe_callback_handler_deregister(0xff);

    spe_context_destroy(context);
    spe_image_close(program);

    return 0;
}
