/*
  Copyright (c) 2009 nosuke <sasugaanija@gmail.com>

  All rights reserved.

  Redistribution and use in source and binary forms, with or
  without modification, are permitted provided that the
  following conditions are met:

  1. Redistributions of source code must retain the above
     copyright notice, this list of conditions and the
     following disclaimer.
  2. Redistributions in binary form must reproduce the above
     copyright notice, this list of conditions and the
     following disclaimer in the documentation and/or other
     materials provided with the distribution.
  3. Neither the name of authors nor the names of its
     contributors may be used to endorse or promote products
     derived from this software without specific prior written
     permission.

  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
  CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
  INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
  DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
  CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
  LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
  HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
  CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
  OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

#include <stdio.h>
#include <string.h>
#include <libspe2.h>

spe_context_ptr_t context;

int
test_handler(void *ls_base, unsigned int ls_addr)
{
    int arg = *((int *)((char *)ls_base + (ls_addr & ~1)));
    unsigned int *args;
    int i;
    spe_spu_control_area_t *ctl;

    printf("ls_addr = 0x%08x\n", ls_addr);

    ctl = spe_ps_area_get(context, SPE_CONTROL_AREA);

    printf("hello world 0x%08x\n", arg);
    args = (unsigned int *)(ls_base + arg);

    for (i = 0; i < 4; i++) {
        printf("args[%d] = 0x%08x\n", i, args[i]);
    }

    args[0] = 0xdeadbeef;
    args[3] = -573;

    printf("SPU_Status = 0x%08x\n", ctl->SPU_Status);
    printf("SPU_NPC = 0x%08x\n", ctl->SPU_NPC);
    printf("SPU_RunCntl = 0x%08x\n", ctl->SPU_RunCntl);

    return 0;
}



int
main(int argc, char *argv[])
{ 
    spe_program_handle_t *program;
    unsigned entry = SPE_DEFAULT_ENTRY;
    spe_stop_info_t stop_info; 

    // 2SPE_CALLBACK_NEWSPE_CALLBACK_UPDATEΤɤ餫
    // Ͽʤԡؤʤ
    // 3ֹꤹ 
    // 0255ޤǤǽ03ͽѤ
    //  0: ISO/IEC C Standard Header
    //  1: POSIX.1 (IEEE Standard 1003.1)
    //  2: POSIX.4
    //  3: Operating system-dependent system calls

    int i;

    for (i = 0; i < 256; i++) {
        void *fn;
        fn = spe_callback_handler_query(i);
        if (fn)
            printf("callnum:%d is used\n", i);
    }

    spe_callback_handler_register(test_handler, 0xff, SPE_CALLBACK_NEW);

    program = spe_image_open("send_to_ppe_spe");
    context = spe_context_create(SPE_MAP_PS | SPE_EVENTS_ENABLE, NULL); 
    spe_program_load(context, program);
    spe_context_run(context, &entry, 0, NULL, NULL, &stop_info);
    spe_context_destroy(context);
    spe_image_close(program);

    return 0;
}
