/*
  Copyright (c) 2009 nosuke <sasugaanija@gmail.com>

  All rights reserved.

  Redistribution and use in source and binary forms, with or
  without modification, are permitted provided that the
  following conditions are met:

  1. Redistributions of source code must retain the above
     copyright notice, this list of conditions and the
     following disclaimer.
  2. Redistributions in binary form must reproduce the above
     copyright notice, this list of conditions and the
     following disclaimer in the documentation and/or other
     materials provided with the distribution.
  3. Neither the name of authors nor the names of its
     contributors may be used to endorse or promote products
     derived from this software without specific prior written
     permission.

  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
  CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
  INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
  DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
  CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
  LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
  HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
  CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
  OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

#include <stdio.h>
#include <spu_intrinsics.h>
#include <spu_mfcio.h>

#include "common.h"

#define TAGID 3

context_ea_t ctx_ea[SPE_NUM] __attribute__((aligned(16)));

unsigned
dma_read4(unsigned long long ea)
{
    unsigned buf[4] __attribute__((aligned(16))); // 饤Ĵ
    unsigned idx = (ea & 0xf) >> 2;
    unsigned mask;

    mask = spu_readch(MFC_RdTagMask);
    spu_writech(MFC_WrTagMask, 1 << 31);

    // EA4Byteɤ߽Ф
    spu_mfcdma64(&buf[idx], (unsigned)(ea >> 32), (unsigned)ea, 4, 31,
                 MFC_GET_CMD);
    spu_mfcstat(MFC_TAG_UPDATE_ALL);

    spu_writech(MFC_WrTagMask, mask);
    return buf[idx];
}


void
dma_write4(unsigned long long ea, unsigned data)
{
    unsigned buf[4] __attribute__((aligned(16))); // 饤Ĵ
    unsigned idx = (ea & 0xf) >> 2;
    unsigned mask;
    
    mask = spu_readch(MFC_RdTagMask);
    spu_writech(MFC_WrTagMask, 1 << 31);

    buf[idx] = data;
    // EA4Byte񤭹
    spu_mfcdma64(&buf[idx], (unsigned)(ea >> 32), (unsigned)ea, 4, 31, 
                 MFC_PUT_CMD);
    spu_mfcstat(MFC_TAG_UPDATE_ALL);
    spu_writech(MFC_WrTagMask, mask);
}


void
spu_mfcdma64_remote(int rspeid, void *ls, unsigned eah, unsigned eal,
                    unsigned size, unsigned tagid, unsigned cmd)
{
    unsigned rd;
    do {
        // ν֤ž뤳Ȥ侩Ƥ
        dma_write4(ctx_ea[rspeid].lsa, (unsigned)ls);
        dma_write4(ctx_ea[rspeid].eah, eah);
        dma_write4(ctx_ea[rspeid].eal, eal);
        dma_write4(ctx_ea[rspeid].size_tag, (size << 16) | tagid);
        dma_write4(ctx_ea[rspeid].classid_cmd, cmd);
        // MFC_CMDStatusɤ߽ФԤʤ׵ϼդʤ
        rd = dma_read4(ctx_ea[rspeid].cmdstatus);
        // ޤޤǷ֤
    } while (rd & 0x3);
}


void
spu_mfcstat_remote(int rspeid, unsigned tagid)
{
    unsigned rd;
    // Υޥ
    dma_write4(ctx_ea[rspeid].querymask, 1 << tagid);
    do {
        // ҤPrxy_TagStatusɤ߽ФtagidбӥåȤΩĤΤԤ
        rd = dma_read4(ctx_ea[rspeid].tagstatus);
    } while (rd != 1 << tagid);
}



unsigned int buf1[4] __attribute__((aligned(16)));
unsigned int buf2[4] __attribute__((aligned(16)));

int
main(unsigned long long spe, unsigned long long argp, unsigned long long envp)
{
    unsigned ppe_buf_eal, ppe_buf_eah, ctx_ea_eal, ctx_ea_eah;
    unsigned d;
    int speid = (int)argp;

    buf1[0] = 0;
    buf2[0] = speid == 1 ? 0xce11b1e1 : 0;
    d = speid;

    // ȤꤢǽPPEmboxΤ SPE·ΤԤäƤ餦
    spu_writech(SPU_WrOutIntrMbox, d);

    // EA᡼ܥåͳǼ
    ppe_buf_eal = spu_readch(SPU_RdInMbox);
    ppe_buf_eah = spu_readch(SPU_RdInMbox);
    ctx_ea_eal = spu_readch(SPU_RdInMbox);
    ctx_ea_eah = spu_readch(SPU_RdInMbox);

    spu_writech(MFC_WrTagMask, 1 << TAGID);

    // LSctx_eaPPE¦Ѱդctx_eaͤɤ߽Ф
    spu_mfcdma64(ctx_ea, ctx_ea_eah, ctx_ea_eal, sizeof(ctx_ea),
                 TAGID, MFC_GET_CMD);
    spu_mfcstat(MFC_TAG_UPDATE_ALL);


    if (speid == 0) {
        // SPE0SPE1MFC˻ؼ
        // PPEΥХåեSPE1buf1˥ǡɤ߽ФؼФ
        spu_mfcdma64_remote(1, buf1, ppe_buf_eah, ppe_buf_eal,
                            sizeof(buf1), TAGID, MFC_GET_CMD);

        // PPEΥХåեSPE1buf2Υǡ񤭹ؼФ
        spu_mfcdma64_remote(1, buf2, ppe_buf_eah, ppe_buf_eal,
                            sizeof(buf2), TAGID, MFC_PUTF_CMD);
        // ؼDMAžޤԤ
        spu_mfcstat_remote(1, TAGID);
    }

    spu_writech(SPU_WrOutIntrMbox, d);
    spu_readch(SPU_RdInMbox);

    /*
    spu_writech(SPU_WrDec, 0xffffffff);
    do {
        d = spu_readch(SPU_RdDec);
    } while (0xffffffff - d < 0x8000000);
    */

    if (speid == 1)
        // SPE1ξbuf1[0]
        printf("SPE%d: buf1: 0x%08x\n", speid, buf1[0]);
    
    return 0;
}
