#include <stdio.h>
#include <spu_mfcio.h>
#include "mt_mine.h"

/* Period parameters */
#define N 624
#define M 397
#define MATRIX_A 0x9908b0dfUL   /* constant vector a */
#define UPPER_MASK 0x80000000UL /* most significant w-r bits */
#define LOWER_MASK 0x7fffffffUL /* least significant r bits */

static unsigned long mt[N] __attribute__((aligned(16))); 
static int mti=N+1; /* mti==N+1 means mt[N] is not initialized */

/* initializes mt[N] with a seed */
void init_genrand_mine(unsigned long s)
{
  mt[0]= s & 0xffffffffUL;
  for (mti=1; mti<N; mti++) {
    mt[mti] =
      (1812433253UL * (mt[mti-1] ^ (mt[mti-1] >> 30)) + mti);
    /* See Knuth TAOCP Vol2. 3rd Ed. P.106 for multiplier. */
    /* In the previous versions, MSBs of the seed affect   */
    /* only MSBs of the array mt[].                        */
    /* 2002/01/09 modified by Makoto Matsumoto             */
    mt[mti] &= 0xffffffffUL;
    /* for >32 bit machines */
  }
}

unsigned
genrand_mine(int num_rand)
{
    unsigned r = 0;
    int i;

    for (i = 0; i < num_rand; i++) {
        unsigned y;
        unsigned mag01[2] = {0x0U, MATRIX_A};

        if (mti >= N) {
            int kk;
            // mtΥåץǡȽ
            for (kk = 0; kk < N; kk++) {
                unsigned mt1 = kk < N - 1 ? mt[kk + 1] : mt[0];
                unsigned mt2 = kk < N - M ? mt[kk + M] : mt[kk + M - N];
                y = (mt[kk] & UPPER_MASK) | (mt1 & LOWER_MASK);
                mt[kk] = mt2 ^ (y >> 1) ^ mag01[y & 0x1U];
            }
            mti = 0;
        }

        y = mt[mti++];

        // Tempering
        y ^= (y >> 11);
        y ^= (y << 7) & 0x9d2c5680U;
        y ^= (y << 15) & 0xefc60000U;
        y ^= (y >> 18);
        r += y;
    }

    return r;
}
