#include <stdio.h>
#include <pthread.h>
#include <libspe2.h>

typedef struct spethread_t {
    int id;
    spe_context_ptr_t context;
    pthread_t pthread;
} spethread_t;

static void *
spethread_fn(void *arg)
{
    spethread_t *spethread = (spethread_t *)arg;
    spe_context_ptr_t context = spethread->context;
    unsigned int entry = SPE_DEFAULT_ENTRY;
    spe_stop_info_t stop_info;

    spe_context_run(context, &entry, 0, (void *)(unsigned long)spethread->id,
                    NULL, &stop_info);

    pthread_exit(NULL);
}


int
main(int argc, char *argv[])
{
    int i, j;
    spe_program_handle_t *program;
    spethread_t spethreads[2];
    int flags = SPE_MAP_PS;

    unsigned mbox_data[4];

    void *ls;

    program = spe_image_open("mt_kadai");

    for (i = 0; i < 2; i++) {
        spethreads[i].id = i;
        spethreads[i].context = spe_context_create(flags, NULL);
        spe_program_load(spethreads[i].context, program);
    }

    for (i = 0; i < 2; i++)
        pthread_create(&spethreads[i].pthread, NULL, &spethread_fn,
                       &spethreads[i]);


    for (i = 0; i < 2; i++) {
        ls = spe_ls_area_get(spethreads[i].context);
        mbox_data[0] = (unsigned)((long)ls >> 32); // high
        mbox_data[1] = (unsigned)(long)ls; // low
        for (j = 0; j < 2; j++)
            spe_in_mbox_write(spethreads[j].context, mbox_data, 2,
                              SPE_MBOX_ALL_BLOCKING);
    }

    for (i = 0; i < 2; i++) {
        pthread_join(spethreads[i].pthread, NULL);
        spe_context_destroy(spethreads[i].context);
    }

    spe_image_close(program);

    return 0;
}
