#include <stdio.h>
#include <stdlib.h>
#include <spu_intrinsics.h>
#include <spu_mfcio.h>
#include <string.h>
#include "mt_mine.h"
#include "mt19937ar.sep/mt19937ar.h"

unsigned char ls_padding[210*1024] = "Do not edit this buffer!";

unsigned ls_high[2], ls_low[2];
int speid;

struct result {
    unsigned int tick;
    unsigned int sum;
};

static struct result run_original(unsigned int seed, unsigned int num_rand)
{
    unsigned int sum = 0;

    init_genrand(seed);

    spu_write_decrementer(~0);
    unsigned int start = spu_read_decrementer();

    for (int i = 0; i < num_rand; i++) {
        sum += genrand_int32();
    }

    unsigned int end = spu_read_decrementer();

    struct result result;
    result.tick = start-end;
    result.sum = sum;

    return result;
}

static struct result run_mine(unsigned int seed, unsigned int num_rand)
{
    unsigned int sum;
    init_genrand_mine(seed);

    spu_write_decrementer(~0);
    unsigned int start = spu_read_decrementer();
    sum = genrand_mine(num_rand);
    unsigned int end = spu_read_decrementer();

    struct result result;
    result.tick = start - end;
    result.sum = sum;

    return result;
}

static int seed_table[][2] = {
    {2029452,58156364},
    {1007804,83893872},
    {6943288,61730988},
    {2778901,57369972},
    {9382722,2841580},
    {1873407,42369816},
    {6146391,58340980},
    {1276756,51339524},
    {5314740,49614528},
    {7054247,1208480},
};

static long compare()
{
    int i;
    int n = sizeof(seed_table)/sizeof(seed_table[0]);
    //unsigned long long time_sum;

    for (i=0; i<210*1024; i++) {
        ls_padding[i] = 0xaa;
    }

    for (i=0; i<n; i++) {
        int seed = seed_table[i][0];
        int num_rand = seed_table[i][1];

        struct result original = run_original(seed, num_rand);
        struct result mine     = run_mine(seed, num_rand);
        if (speid == 1) {
            printf("ORIGNAL:         sum=%08x, %d ticks\n", original.sum, original.tick);
            printf("MINE:            sum=%08x, %d ticks\n", mine.sum, mine.tick);
          if (original.sum != mine.sum) {
          puts("error!!");
          exit(1);
          }
        }

    }

    for (i=0; i<210*1024; i++) {
        if (ls_padding[i] != 0xaa)
            puts("ls_padding is corrupted.");
    }
}


int main(unsigned long long spe,
         unsigned long long argp,
         unsigned long long envp)
{
    int i;
    speid = (int)argp;

    for (i = 0; i < 2; i++) {
        ls_high[i] = spu_readch(SPU_RdInMbox);
        ls_low[i] = spu_readch(SPU_RdInMbox);
    }

    compare();
    return 0;
}
