/*
  Copyright (c) 2009 nosuke <sasugaanija@gmail.com>

  All rights reserved.

  Redistribution and use in source and binary forms, with or
  without modification, are permitted provided that the
  following conditions are met:

  1. Redistributions of source code must retain the above
     copyright notice, this list of conditions and the
     following disclaimer.
  2. Redistributions in binary form must reproduce the above
     copyright notice, this list of conditions and the
     following disclaimer in the documentation and/or other
     materials provided with the distribution.
  3. Neither the name of authors nor the names of its
     contributors may be used to endorse or promote products
     derived from this software without specific prior written
     permission.

  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
  CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
  INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
  DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
  CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
  LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
  HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
  CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
  OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

#include <stdio.h>
#include <libspe2.h> // libspe2SPE椹ɬinclude

int
main(int argc, char *argv[])
{ 
    spe_program_handle_t *program;
    spe_context_ptr_t context;
    unsigned entry = SPE_DEFAULT_ENTRY;

    // SPEץ (Ʊǥ쥯ȥˤhello_spe) 򳫤
    if ((program = spe_image_open("hello_spe")) == NULL) {
        perror("spe_image_open");
        return -1;
    }
    // SPEƥȤ
    context = spe_context_create(SPE_MAP_PS, NULL); 
    // SPEƥȤhello_speȤ
    spe_program_load(context, program);

    printf("start SPE program\n");
    // SPEƥȤ¹
    spe_context_run(context, &entry, 0, NULL, NULL, NULL);
    printf("done\n");

    // SPEƥȤ˴
    spe_context_destroy(context);
    // SPEץĤ
    spe_image_close(program);

    return 0;
}
