/*
  Copyright (c) 2009 nosuke <sasugaanija@gmail.com>

  All rights reserved.

  Redistribution and use in source and binary forms, with or
  without modification, are permitted provided that the
  following conditions are met:

  1. Redistributions of source code must retain the above
     copyright notice, this list of conditions and the
     following disclaimer.
  2. Redistributions in binary form must reproduce the above
     copyright notice, this list of conditions and the
     following disclaimer in the documentation and/or other
     materials provided with the distribution.
  3. Neither the name of authors nor the names of its
     contributors may be used to endorse or promote products
     derived from this software without specific prior written
     permission.

  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
  CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
  INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
  DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
  CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
  LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
  HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
  CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
  OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

#include <stdio.h>
#include <spu_intrinsics.h>
#include <spu_mfcio.h>

#define TAGID 3

int
main(unsigned long long spe, unsigned long long argp, unsigned long long envp)
{
    unsigned eal, eah, d;
    int speid = (int)argp;

    // DMAѤΥХåե16Byte˥饤󤷤֤ǳ
    unsigned int dma_buf[4] __attribute__((aligned(16)));

    // EA᡼ܥåͳǼ
    eal = spu_readch(SPU_RdInMbox);
    eah = spu_readch(SPU_RdInMbox);

    // ޥ (TAGIDΤߴλǧ褦)
    spu_writech(MFC_WrTagMask, 1 << TAGID);

    // 16ByteΥǡ ((eah << 32) | eal) dma_bufDMAž׵
    spu_mfcdma64(dma_buf, eah, eal, 16, TAGID, MFC_GET_CMD);
    // ޥǻꤷ׵᤬λȤʤޤԵ
    spu_mfcstat(MFC_TAG_UPDATE_ALL);

    printf("SPE%d: dma_buf[0] = 0x%08x\n", speid, dma_buf[0]);

    // dma_bufɤ߽ФͤƬɤ򹹿
    dma_buf[0]++;

    // dma_buf16ByteΥǡۤɤ߽ФȤ˽񤭹
    spu_mfcdma64(dma_buf, eah, eal, 16, TAGID, MFC_PUT_CMD);
    // ޥǻꤷ׵᤬λȤʤޤԵ
    d = spu_mfcstat(MFC_TAG_UPDATE_ALL);

    // spu_mfcstatͤϡޥꤵ줿ͤ
    // ¸׵ΥΥӥåȤ򲼤ͤˤʤ
    printf("SPE%d: d = 0x%08x\n", speid, d);

    return 0;
}
