/*
  Copyright (c) 2009 nosuke <sasugaanija@gmail.com>

  All rights reserved.

  Redistribution and use in source and binary forms, with or
  without modification, are permitted provided that the
  following conditions are met:

  1. Redistributions of source code must retain the above
     copyright notice, this list of conditions and the
     following disclaimer.
  2. Redistributions in binary form must reproduce the above
     copyright notice, this list of conditions and the
     following disclaimer in the documentation and/or other
     materials provided with the distribution.
  3. Neither the name of authors nor the names of its
     contributors may be used to endorse or promote products
     derived from this software without specific prior written
     permission.

  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
  CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
  INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
  DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
  CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
  LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
  HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
  CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
  OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

#include <stdio.h>
#include <spu_intrinsics.h>
#include <spu_mfcio.h>

#define SEM 3

unsigned atomic_buf[128 / sizeof(unsigned)] __attribute__((aligned(128)));
int test_buf[128 / sizeof(int)] __attribute__((aligned(128)));

unsigned eal, eah;

// P̿
int
p()
{
    int ret = 0;
    unsigned stat;
    // getllarǥޥեѿɤ߽Ф
    spu_mfcdma64(atomic_buf, eah, eal, 128, 0, MFC_GETLLAR_CMD);
    spu_readch(MFC_RdAtomicStat);
    if (atomic_buf[0] > 0) {
        // ޥեѿ0ʾä󥹤
        // ޥեѿ򥢥ȥߥå˥ǥȤ뤳Ȥĩ
        atomic_buf[0]--;
        spu_mfcdma64(atomic_buf, eah, eal, 128, 0, MFC_PUTLLC_CMD);
        stat = spu_readch(MFC_RdAtomicStat);
        // Ԥ0ǥΥޥեѿ֤ͤ
        ret = (stat & MFC_PUTLLC_STATUS) ? 0 : (int)atomic_buf[0] + 1;
    }
    return ret; // < 0: 顼, 0: , > 0: 
}


// V̿
void
v()
{
    do {
        // getllarǥޥեѿɤ߽Ф
        spu_mfcdma64(atomic_buf, eah, eal, 128, 0, MFC_GETLLAR_CMD);
        spu_readch(MFC_RdAtomicStat);
        // ޥեѿ򥢥ȥߥå˥󥯥Ȥ뤳Ȥĩ
        atomic_buf[0]++;
        spu_mfcdma64(atomic_buf, eah, eal, 128, 0, MFC_PUTLLC_CMD);
        // ԤƤ餺ˡޤǷ֤
    } while (spu_readch(MFC_RdAtomicStat) & MFC_PUTLLC_STATUS);
}

#define TAGID 3


int
main(unsigned long long spe, unsigned long long argp, unsigned long long envp)
{
    unsigned test_eal, test_eah;
    int speid = (int)argp;
    int i;

    eal = spu_readch(SPU_RdInMbox);
    eah = spu_readch(SPU_RdInMbox);

    test_eal = spu_readch(SPU_RdInMbox);
    test_eah = spu_readch(SPU_RdInMbox);

    spu_writech(MFC_WrTagMask, 1 << TAGID); 

    for (i = 0; i < 10000; i++) {
        // P̿᤬ޤǲ٤ƤӽФ
        while (p() <= 0)
            ;

        // ݤɤΰ
        // SEMĤޤǤSPEƱˤ뤳ȤǤ

        // ޤ㤬ĤʤäΤǡݤɤΰǤ
        // 絭ζͭѿ¾
        do {
            spu_mfcdma64(test_buf, test_eah, test_eal, 128, 0, MFC_GETLLAR_CMD);
            spu_readch(MFC_RdAtomicStat);

            if (test_buf[0] <= 0 || test_buf[0] > SEM)
                // 0ʲSEM礭ͤɤ᤿硤¾漺
                printf("*** SPE%d: CRITICAL: test_buf[0] = %d\n", speid,
                       test_buf[0]);

            test_buf[0]--;

            spu_mfcdma64(test_buf, test_eah, test_eal, 128, 0, MFC_PUTLLC_CMD);
        } while (spu_readch(MFC_RdAtomicStat) & MFC_PUTLLC_STATUS);


        do {
            spu_mfcdma64(test_buf, test_eah, test_eal, 128, 0, MFC_GETLLAR_CMD);
            spu_readch(MFC_RdAtomicStat);

            if (test_buf[0] < 0 || test_buf[0] >= SEM)
                // 0̤SEMʾͤɤ᤿硤¾漺
                printf("*** SPE%d: CRITICAL: test_buf[0] = %d\n", speid,
                       test_buf[0]);

            test_buf[0]++;

            spu_mfcdma64(test_buf, test_eah, test_eal, 128, 0, MFC_PUTLLC_CMD);
        } while (spu_readch(MFC_RdAtomicStat) & MFC_PUTLLC_STATUS);
        
        // ޤǺݤɤΰ

        // V̿ޤʤˤΤ1Ƥ
        v();
    }

    return 0;
}
