/*
  Copyright (c) 2009 nosuke <sasugaanija@gmail.com>

  All rights reserved.

  Redistribution and use in source and binary forms, with or
  without modification, are permitted provided that the
  following conditions are met:

  1. Redistributions of source code must retain the above
     copyright notice, this list of conditions and the
     following disclaimer.
  2. Redistributions in binary form must reproduce the above
     copyright notice, this list of conditions and the
     following disclaimer in the documentation and/or other
     materials provided with the distribution.
  3. Neither the name of authors nor the names of its
     contributors may be used to endorse or promote products
     derived from this software without specific prior written
     permission.

  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
  CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
  INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
  DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
  CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
  LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
  HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
  CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
  OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

#include <stdio.h>
#include <spu_intrinsics.h>
#include <spu_mfcio.h>

// ȥߥåѤΰ (128Byteɬ)
unsigned atomic_buf[128 / sizeof(unsigned)] __attribute__((aligned(128)));

int
main(unsigned long long spe, unsigned long long argp, unsigned long long envp)
{
    unsigned eal, eah;
    int speid = (int)argp;
    int i;
    int try = 0;

    eal = spu_readch(SPU_RdInMbox);
    eah = spu_readch(SPU_RdInMbox);

    // SPE100000ͭΰͤ򥤥󥯥Ȥ
    for (i = 0; i < 100000; i++) {
        do {
            // 絭ζͭѿͤgetllarɤ߽Ф
            spu_mfcdma64(atomic_buf, eah, eal, 128, 0, MFC_GETLLAR_CMD); 
            // getllarɬMFC_RdAtomicStatɤǴλǧ
            spu_readch(MFC_RdAtomicStat);

            // Ȥꤢɤͤ򥤥󥯥
            atomic_buf[0]++;

            // ͤޤǤ˻Բ
            try++;

            // putllcǽᤷ
            // ɤ߽ФƤ᤹ޤǤδ֤ˡ¾ïˤⶦͭΰ褬
            // ƤʤäϤ
            spu_mfcdma64(atomic_buf, eah, eal, 128, 0, MFC_PUTLLC_CMD);

            // MFC_RdAtomicStatɤͤMFC_PUTLLC_STATUSΩä
            // ԤʤΤǡɤ߽Фľ
        } while (spu_readch(MFC_RdAtomicStat) & MFC_PUTLLC_STATUS);
    }

    printf("SPE[%d]: try = %d\n", speid, try);
    
    return 0;
}
