/*
  Copyright (c) 2009 nosuke <sasugaanija@gmail.com>

  All rights reserved.

  Redistribution and use in source and binary forms, with or
  without modification, are permitted provided that the
  following conditions are met:

  1. Redistributions of source code must retain the above
     copyright notice, this list of conditions and the
     following disclaimer.
  2. Redistributions in binary form must reproduce the above
     copyright notice, this list of conditions and the
     following disclaimer in the documentation and/or other
     materials provided with the distribution.
  3. Neither the name of authors nor the names of its
     contributors may be used to endorse or promote products
     derived from this software without specific prior written
     permission.

  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
  CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
  INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
  DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
  CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
  LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
  HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
  CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
  OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/


#include <spu_intrinsics.h>
#include <stdio.h>

#define CARRY_PATTERN                                            \
    (vec_uchar16){0x80, 0x80, 0x80,  7, 0x80, 0x80, 0x80, 0x80,  \
                  0x80, 0x80, 0x80, 15, 0x80, 0x80, 0x80, 0x80}

vec_llong2
add_llong2(vec_llong2 a, vec_llong2 b)
{
    vec_int4 c;
    // spu_gencǰ褦vec_int4˥㥹Ȥ
    c = spu_genc((vec_int4)a, (vec_int4)b);
    // word1word3η̤word0word2˰ܤword1word3ϥ
    c = spu_shuffle(c, c, CARRY_PATTERN);
    return (vec_llong2)spu_addx((vec_int4)a, (vec_int4)b, c);
}


int
main()
{
    vec_llong2 vll1, vll2, vll3;
    long long ll1, ll2, ll3, lltmp;

    vll1 = (vec_llong2){0x9a235508aa132413LL, 0x4800abe1ff237781LL};
    vll2 = (vec_llong2){0x4120394af8a1beefLL, 0x79301acda13da098LL};

    // SIMD黻ˤ64bit­ƤӽФ
    vll3 = add_llong2(vll1, vll2);

    // Ƿ׻Ӥ碌
    ll1 = spu_extract(vll1, 0);
    ll2 = spu_extract(vll2, 0);
    ll3 = ll1 + ll2;
    lltmp = spu_extract(vll3, 0);

    if (lltmp != ll3)
        printf("doubleword0 Failed\n");
    else 
        printf("doubleword0 OK\n");

    printf("add_llong2:  0x%016llx\n", lltmp);
    printf("answer:      0x%016llx\n", ll3);

    ll1 = spu_extract(vll1, 1);
    ll2 = spu_extract(vll2, 1);
    ll3 = ll1 + ll2;
    lltmp = spu_extract(vll3, 1);

    if (lltmp != ll3)
        printf("doubleword1 Failed\n");
    else 
        printf("doubleword1 OK\n");

    printf("add_llong2:  0x%016llx\n", lltmp);
    printf("answer:      0x%016llx\n", ll3);

    return 0;
}
