/*
  Copyright (c) 2009 nosuke <sasugaanija@gmail.com>

  All rights reserved.

  Redistribution and use in source and binary forms, with or
  without modification, are permitted provided that the
  following conditions are met:

  1. Redistributions of source code must retain the above
     copyright notice, this list of conditions and the
     following disclaimer.
  2. Redistributions in binary form must reproduce the above
     copyright notice, this list of conditions and the
     following disclaimer in the documentation and/or other
     materials provided with the distribution.
  3. Neither the name of authors nor the names of its
     contributors may be used to endorse or promote products
     derived from this software without specific prior written
     permission.

  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
  CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
  INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
  DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
  CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
  LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
  HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
  CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
  OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

#include <stdio.h>
#include <spu_intrinsics.h>
#include <simdmath/divf4.h> /* divf4APIȤĥإåinclude */

int
main(unsigned long long spe, unsigned long long argp, unsigned long long envp)
{
    int i;
    vec_float4 funit = (vec_float4){1.0, 1.0, 1.0, 1.0};
    vec_float4 f1 = (vec_float4){1.0, 2.0, 3.0, 4.0}, f2, f3;

    /* divf4ϡ_divf4פȤ̾ǸƤ֤Ȥǥ饤Ÿǽ */
    f2 = _divf4(funit, f1); 
    /* ͤޤǤspu_reñΤǵտ׻ */
    f3 = spu_re(f1);

    printf("_divf4: ");
    for (i = 0; i < 4; i++)
        printf("%f ", spu_extract(f2, i));
    printf("\n");

    printf("spu_re: ");
    for (i = 0; i < 4; i++)
        printf("%f ", spu_extract(f3, i));
    printf("\n");

    return 0;
}
