/*
  Copyright (c) 2009 nosuke <sasugaanija@gmail.com>

  All rights reserved.

  Redistribution and use in source and binary forms, with or
  without modification, are permitted provided that the
  following conditions are met:

  1. Redistributions of source code must retain the above
     copyright notice, this list of conditions and the
     following disclaimer.
  2. Redistributions in binary form must reproduce the above
     copyright notice, this list of conditions and the
     following disclaimer in the documentation and/or other
     materials provided with the distribution.
  3. Neither the name of authors nor the names of its
     contributors may be used to endorse or promote products
     derived from this software without specific prior written
     permission.

  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
  CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
  INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
  DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
  CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
  LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
  HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
  CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
  OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

#include <stdio.h>
#include <spu_intrinsics.h>
#include <ea.h>

int
main(unsigned long long spe, unsigned long long argp, unsigned long long envp)
{
#ifndef PPE64
    unsigned ea;
#else
    volatile unsigned long long ea __attribute__((aligned(16)));
#endif
    unsigned eah, eal;

#ifndef PPE64
    /* 32bit */
    ea = (unsigned)malloc_ea(128);
    eah = 0;
    eal = ea;
#else
    /* 64bit */
# if 1
    /* stop-and-signalƤ٤64bitǤǤư */
#  define JSRE_LIBEA_SIGNALCODE 0x2105
#  define SPE_LIBEA_MALLOC 0x03
    unsigned long long size = 128;
    __send_to_ppe(JSRE_LIBEA_SIGNALCODE, SPE_LIBEA_MALLOC , &size);
    ea = size;
    eah = (unsigned)(ea >> 32);
    eal = (unsigned)ea;
# else
    /* ̤ˤȤ64bitǤǤưʤ ⤽ͤ */
    ea = (unsigned long long)malloc_ea(128);
    eah = (unsigned)(ea >> 32);
    eal = (unsigned)ea;
# endif
#endif

    printf("EAH: 0x%08x\n", eah);
    printf("EAL: 0x%08x\n", eal);

    if (ea == 0) {
        printf("malloc_ea failed\n");
        return -1;
    }

    return 0;
}

