/*
  Copyright (c) 2009 nosuke <sasugaanija@gmail.com>

  All rights reserved.

  Redistribution and use in source and binary forms, with or
  without modification, are permitted provided that the
  following conditions are met:

  1. Redistributions of source code must retain the above
     copyright notice, this list of conditions and the
     following disclaimer.
  2. Redistributions in binary form must reproduce the above
     copyright notice, this list of conditions and the
     following disclaimer in the documentation and/or other
     materials provided with the distribution.
  3. Neither the name of authors nor the names of its
     contributors may be used to endorse or promote products
     derived from this software without specific prior written
     permission.

  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
  CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
  INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
  DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
  CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
  LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
  HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
  CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
  OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

#include <stdio.h>
#include <spu_mfcio.h>

/* ꥹDMAžΤlistdma_spe.cƱ */

#define LIST_NUM 128
#define BLOCK_SIZE 16
#define INTERVAL 128
#define TAGID 3

unsigned char dma_buf[BLOCK_SIZE * LIST_NUM] __attribute__((aligned(16))) = {0};
mfc_list_element_t dma_list[LIST_NUM] __attribute__((aligned(16))) = {{0}};

int
main(unsigned long long spe, unsigned long long argp, unsigned long long envp)
{
    int i;
    unsigned eal, eah;

    eal = spu_readch(SPU_RdInMbox);
    eah = spu_readch(SPU_RdInMbox);

    for (i = 0; i < sizeof(dma_buf); i++)
        dma_buf[i] = (unsigned char)i;

    for (i = 0; i < LIST_NUM; i++) {
        dma_list[i].size = BLOCK_SIZE;
        dma_list[i].eal = eal;
        /* notifyФ1񤤤Ƥ */
        dma_list[i].notify = 1;
        eal += INTERVAL;
    }

    mfc_write_tag_mask(1 << TAGID);

    spu_mfcdma64(dma_buf, eah, (unsigned)dma_list,
                 sizeof(mfc_list_element_t) * LIST_NUM, TAGID, MFC_PUTL_CMD);

    /* DMA׵塤ɬLIST_NUM - 1ꥹDMAΥȡ뤬ȯϤʤΤ
       ԤԤ (ǸǤϥȡ뤷ʤ) */
    for (i = 0; i < LIST_NUM - 1; i++) {
        /* MFC_RdListStallStatɤߤ˹ԤȥꥹDMAȡ뤹ޤ
           SPUȡ뤹ΤǡꥹDMAȡ뤹
           ɤ߽ФƤʤ */
        spu_readch(MFC_RdListStallStat);
        /* ä˲⤻˥ȡ */
        spu_writech(MFC_WrListStallAck, TAGID);
    }

    spu_mfcstat(MFC_TAG_UPDATE_ALL);

    return 0;
}


