/*
  Copyright (c) 2009 nosuke <sasugaanija@gmail.com>

  All rights reserved.

  Redistribution and use in source and binary forms, with or
  without modification, are permitted provided that the
  following conditions are met:

  1. Redistributions of source code must retain the above
     copyright notice, this list of conditions and the
     following disclaimer.
  2. Redistributions in binary form must reproduce the above
     copyright notice, this list of conditions and the
     following disclaimer in the documentation and/or other
     materials provided with the distribution.
  3. Neither the name of authors nor the names of its
     contributors may be used to endorse or promote products
     derived from this software without specific prior written
     permission.

  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
  CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
  INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
  DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
  CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
  LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
  HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
  CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
  OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

#include <stdio.h>
#include <pthread.h> /* pthreadѤΤinclude */
#include <libspe2.h>

/* ƥåɤ뤿ι¤ */
typedef struct spethread_t {
    int id;
    spe_context_ptr_t context;
    pthread_t pthread;
} spethread_t;


/* ƥåɤ¹Ԥؿ */
static void *
spethread_fn(void *arg)
{
    spethread_t *spethread = (spethread_t *)arg;
    spe_context_ptr_t context = spethread->context;
    unsigned int entry = SPE_DEFAULT_ENTRY;
    spe_stop_info_t stop_info;
    spe_context_run(context, &entry, 0, (void *)(unsigned long)spethread->id,
                    NULL, &stop_info);
    pthread_exit(NULL);
}

#define SPE_NUM 6

int
main(int argc, char *argv[])
{ 
    spe_program_handle_t *program;
    spethread_t spethreads[SPE_NUM];
    int i, flags = SPE_MAP_PS;

    program = spe_image_open("hello6_spe");

    /* SPEͤ */
    for (i = 0; i < SPE_NUM; i++) {
        spethreads[i].id = i;
        spethreads[i].context = spe_context_create(flags, NULL); 
        spe_program_load(spethreads[i].context, program);
    }

    printf("start SPE programs\n");

    /* SPEΥƥȤ¹Ԥƥåɤ */
    for (i = 0; i < SPE_NUM; i++)
        pthread_create(&spethreads[i].pthread, NULL, &spethread_fn,
                       &spethreads[i]);

    /* SPEΥƥȤ¹ԤƥåɤνλԤäƥƥȤ˴ */
    for (i = 0; i < SPE_NUM; i ++) {
        pthread_join(spethreads[i].pthread, NULL);
        spe_context_destroy(spethreads[i].context);
    }

    spe_image_close(program);

    printf("done\n");

    return 0;
}
