/*
  Copyright (c) 2009 nosuke <sasugaanija@gmail.com>

  All rights reserved.

  Redistribution and use in source and binary forms, with or
  without modification, are permitted provided that the
  following conditions are met:

  1. Redistributions of source code must retain the above
     copyright notice, this list of conditions and the
     following disclaimer.
  2. Redistributions in binary form must reproduce the above
     copyright notice, this list of conditions and the
     following disclaimer in the documentation and/or other
     materials provided with the distribution.
  3. Neither the name of authors nor the names of its
     contributors may be used to endorse or promote products
     derived from this software without specific prior written
     permission.

  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
  CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
  INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
  DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
  CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
  LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
  HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
  CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
  OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/


#include <spu_intrinsics.h>
#include <stdio.h>

unsigned int d[] __attribute__((aligned(16))) = {1, 2, 3, 4, 5, 6, 7, 8};
 
int
main()
{
    int i;
    vec_uint4 *vup1, *vup2;
    vec_uint4 vu1, vu2;

    vup1 = (vec_uint4 *)d;
    vup2 = (vec_uint4 *)(d + 1);
    vu1 = *vup1;
    vu2 = *vup2;

    /* dvup1vup2Υɥ쥹 */
    printf("&d[0] = %p\n", &d[0]);
    printf("vup1 = %p\n", vup1);
    printf("vup2 = %p\n", vup2);

    /* vu216byte饤󤷤Ƥʤɥ쥹ʤΤvu1vu2ƤƱˤʤ */
    printf("vu1: ");
    for (i = 0; i < 4; i++) {
        printf("%02x ", spu_extract(vu1, i));
    }
    printf("\n");

    printf("vu2: ");
    for (i = 0; i < 4; i++) {
        printf("%02x ", spu_extract(vu2, i));
    }
    printf("\n");

    return 0;
}
