/*
  Copyright (c) 2009 nosuke <sasugaanija@gmail.com>

  All rights reserved.

  Redistribution and use in source and binary forms, with or
  without modification, are permitted provided that the
  following conditions are met:

  1. Redistributions of source code must retain the above
     copyright notice, this list of conditions and the
     following disclaimer.
  2. Redistributions in binary form must reproduce the above
     copyright notice, this list of conditions and the
     following disclaimer in the documentation and/or other
     materials provided with the distribution.
  3. Neither the name of authors nor the names of its
     contributors may be used to endorse or promote products
     derived from this software without specific prior written
     permission.

  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
  CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
  INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
  DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
  CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
  LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
  HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
  CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
  OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

#include <stdio.h>
#include <spu_intrinsics.h>
#include <spu_mfcio.h>
#include <spu_timer.h> /* SLIHȤinclude */

#define TIMEBASE 79800000

volatile unsigned dec_loop = 0;

/* ǥ1SLIH */
unsigned
decrementer_handler(unsigned status)
{
    /* 1Ƥ */
    dec_loop++;
    /* statusե饰򲼤 (ʤȺ٤δؿƤФ) */
    return status & ~MFC_DECREMENTER_EVENT;
}

/* ʥ븡лSLIH */
unsigned
signal_handler(unsigned status)
{
    unsigned d;

    if (status & MFC_SIGNAL_NOTIFY_1_EVENT) {
        /* ʥ1򸡽Ф顤ɤ߽Фstatusե饰򲼤 */
        d = spu_readch(SPU_RdSigNotify1);
        printf("signal notify #1: 0x%08x\n", d);
        status &= ~MFC_SIGNAL_NOTIFY_1_EVENT;
    }

    if (status & MFC_SIGNAL_NOTIFY_2_EVENT) {
        /* ʥ2򸡽Ф顤ɤ߽Фstatusե饰򲼤 */
        d = spu_readch(SPU_RdSigNotify2);
        printf("signal notify #2: 0x%08x\n", d);
        status &= ~MFC_SIGNAL_NOTIFY_2_EVENT;
    }

    return status;
}


int
main(unsigned long long spe, unsigned long long argp, unsigned long long envp)
{
    unsigned d, dec;
    float sec;

    
    /* ǥ1ȥʥθФSLIHϿ */
    spu_slih_register(MFC_DECREMENTER_EVENT, decrementer_handler);
    spu_slih_register(MFC_SIGNAL_NOTIFY_1_EVENT | MFC_SIGNAL_NOTIFY_2_EVENT,
                      signal_handler);

    /* ǥ1ȥʥΤߤ򸡽Ф褦٥ȥޥ */
    spu_writech(SPU_WrEventMask, MFC_DECREMENTER_EVENT
                                 | MFC_SIGNAL_NOTIFY_1_EVENT
                                 | MFC_SIGNAL_NOTIFY_2_EVENT);

    /* եȥ।٥Ȥ */
    while (spu_readchcnt(SPU_RdEventStat) > 0) {
        d = spu_readch(SPU_RdEventStat);
        spu_writech(SPU_WrEventAck, d);
        if (spu_readchcnt(SPU_RdSigNotify1) > 0)
            spu_readch(SPU_RdSigNotify1);
        if (spu_readchcnt(SPU_RdSigNotify2) > 0)
            spu_readch(SPU_RdSigNotify2);
    }

    /* ǥ󥿽 */
    spu_writech(SPU_WrDec, 0xffffffffU);

    /* ٥Ȥˤͭ */
    spu_ienable();

    /* ᡼ܥå񤫤ޤǥȡ뤷Ե
       (δ֤ߤˤбǽ) */
    d = spu_readch(SPU_RdInMbox);

    /* ǥ󥿤ɤ */
    dec = spu_readch(SPU_RdDec);

    /* ȡǲ÷Ϥ׻ */
    sec = (float)(0xffffffffU - dec) / (float)TIMEBASE;
    sec += (float)0xffffffffU * (float)dec_loop / (float)TIMEBASE;

    printf("elapsed time: %fsec\n", sec);

    return 0;
}
