/*
  Copyright (c) 2009 nosuke <sasugaanija@gmail.com>

  All rights reserved.

  Redistribution and use in source and binary forms, with or
  without modification, are permitted provided that the
  following conditions are met:

  1. Redistributions of source code must retain the above
     copyright notice, this list of conditions and the
     following disclaimer.
  2. Redistributions in binary form must reproduce the above
     copyright notice, this list of conditions and the
     following disclaimer in the documentation and/or other
     materials provided with the distribution.
  3. Neither the name of authors nor the names of its
     contributors may be used to endorse or promote products
     derived from this software without specific prior written
     permission.

  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
  CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
  INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
  DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
  CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
  LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
  HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
  CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
  OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

#include <stdio.h>
#include <pthread.h>
#include <libspe2.h>

typedef struct spethread_t {
    int id;
    spe_context_ptr_t context;
    pthread_t pthread;
} spethread_t;

static void *
spethread_fn(void *arg)
{
    spethread_t *spethread = (spethread_t *)arg;
    spe_context_ptr_t context = spethread->context;
    unsigned int entry = SPE_DEFAULT_ENTRY;
    spe_stop_info_t stop_info;
    spe_context_run(context, &entry, 0, (void *)(unsigned long)spethread->id,
                    NULL, &stop_info);
    pthread_exit(NULL);
}


int
main(int argc, char *argv[])
{
    spe_program_handle_t *program;
    spethread_t spethreads;
    int flags = SPE_MAP_PS;

    unsigned mbox_data;

    char cmd[128];

    program = spe_image_open("event_spe");

    spethreads.id = 0;
    spethreads.context = spe_context_create(flags, NULL);
    spe_program_load(spethreads.context, program);

    printf("start SPE program\n");
    pthread_create(&spethreads.pthread, NULL, &spethread_fn,
                   &spethreads);

    /* ĶŬ÷󥿥ե */
    printf("press h to display help\n");
    
    printf("> ");
    while (fgets(cmd, sizeof(cmd), stdin)) {
        int last = 0;
        fflush(stdout);
        switch (cmd[0]) {
        case 'q':
            /* qϤ줿齪λ */
            last = 1;
            break;
        case '1':
            /* 1Ϥ줿饷ʥ1ͤ */
            spe_signal_write(spethreads.context, SPE_SIG_NOTIFY_REG_1,
                             0x12345678);
            break;
        case '2':
            /* 2Ϥ줿饷ʥ2ͤ */
            spe_signal_write(spethreads.context, SPE_SIG_NOTIFY_REG_2,
                             0xcbeace11);
            break;
        case 'h':
        default:
            printf("1: send signal1\n");
            printf("2: send signal2\n");
            printf("q: quit\n");
            printf("h: show this message\n");
        }
        if (last)
            break;
        printf("> ");
        fflush(stdout);
    }


    /* λ褦SPE˥å */
    spe_in_mbox_write(spethreads.context, &mbox_data, 1,
                      SPE_MBOX_ALL_BLOCKING);

    pthread_join(spethreads.pthread, NULL);
    spe_context_destroy(spethreads.context);

    spe_image_close(program);

    printf("done\n");

    return 0;
}
