/*
  Copyright (c) 2009 nosuke <sasugaanija@gmail.com>

  All rights reserved.

  Redistribution and use in source and binary forms, with or
  without modification, are permitted provided that the
  following conditions are met:

  1. Redistributions of source code must retain the above
     copyright notice, this list of conditions and the
     following disclaimer.
  2. Redistributions in binary form must reproduce the above
     copyright notice, this list of conditions and the
     following disclaimer in the documentation and/or other
     materials provided with the distribution.
  3. Neither the name of authors nor the names of its
     contributors may be used to endorse or promote products
     derived from this software without specific prior written
     permission.

  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
  CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
  INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
  DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
  CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
  LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
  HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
  CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
  OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

#include <stdio.h>
#include <spu_intrinsics.h>
#include <spu_mfcio.h>

#define SPE_NUM 6
static unsigned long long ls_addr[SPE_NUM] __attribute__((aligned(16)));
/* ƱѥХåե */
static volatile unsigned b[SPE_NUM][128 / sizeof(unsigned)] = {{0}};

#define TAGID 7

int speid;
unsigned eal, eah;

#define TIMEBASE 79800000

/* Ʊ */
void
barrier()
{
    int i;
    unsigned long long ealsa;

    if (__builtin_expect((speid == 0), 0)) {
        /* SPE0ϡʳSPEDMAbǤΤԤ */
        for (i = 1; i < SPE_NUM; i++) {
            while (!b[i][0])
                ;
            b[i][0] = 0;
        }
        /* SPEιǧ顤SPEDMAǲ */
        for (i = 1; i < SPE_NUM; i++) {
            ealsa = ls_addr[i] + (unsigned)b;
            eah = ealsa >> 32;
            eal = (unsigned)ealsa;
            spu_mfcdma64(&b[0][0], eah, eal, 128, TAGID, MFC_PUT_CMD);
        }
        // spu_mfcstat(MFC_TAG_UPDATE_ALL); /**/
    } else {
        /* SPE0ʳSPESPE0bDMAͤ񤭡ãȤ */
        ealsa = ls_addr[0] + (unsigned)&b[speid][0];
        eah = ealsa >> 32;
        eal = (unsigned)ealsa;
        spu_mfcdma64(&b[speid][0], eah, eal, 128, TAGID, MFC_PUT_CMD);
        // spu_mfcstat(MFC_TAG_UPDATE_ALL);  /**/
        /* SPE0Τ񤫤ΤԤ */
        while (!b[0][0])
            ;
        b[0][0] = 0;
    }
}


int
main(unsigned long long spe, unsigned long long argp, unsigned long long envp)
{
    int i, j;
    float loop_time;

    speid = (int)argp;

    for (i = 0; i < SPE_NUM; i++) {
        b[i][0] = 0;
    }
    b[speid][0] = 1;

    eal = spu_readch(SPU_RdInMbox);
    eah = spu_readch(SPU_RdInMbox);

    spu_writech(MFC_WrTagMask, 1 << TAGID); 

    /* ls_addrޤ뤴DMAɤ߽Ф */
    spu_mfcdma64(ls_addr, eah, eal, sizeof(ls_addr), TAGID, MFC_GET_CMD); 
    spu_mfcstat(MFC_TAG_UPDATE_ALL);


#define LOOP 10000000

    /* ǥ󥿽 */
    spu_writech(SPU_WrDec, 0xffffffff);

    /* LOOPSPEƱ */
    for (j = 0; j < LOOP; j++)
        barrier();

    /* ǥ󥿤κʬô */
    loop_time = (float)(0xffffffff - spu_readch(SPU_RdDec)) / (float)TIMEBASE;

    printf("%fsec\n", loop_time);

    return 0;
}
