/*
  Copyright (c) 2009 nosuke <sasugaanija@gmail.com>

  All rights reserved.

  Redistribution and use in source and binary forms, with or
  without modification, are permitted provided that the
  following conditions are met:

  1. Redistributions of source code must retain the above
     copyright notice, this list of conditions and the
     following disclaimer.
  2. Redistributions in binary form must reproduce the above
     copyright notice, this list of conditions and the
     following disclaimer in the documentation and/or other
     materials provided with the distribution.
  3. Neither the name of authors nor the names of its
     contributors may be used to endorse or promote products
     derived from this software without specific prior written
     permission.

  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
  CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
  INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
  DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
  CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
  LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
  HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
  CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
  OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

#include <stdio.h>
#include <spu_intrinsics.h>
#include <spu_mfcio.h>

#define SEM 3

unsigned atomic_buf[128 / sizeof(unsigned)] __attribute__((aligned(128)));

int test_buf[128 / sizeof(int)] __attribute__((aligned(128)));

unsigned eal, eah;

/* åؿ */
void
mutex_lock()
{
    do {
        /* getllarǶͭѿɤ߽Ф */
        spu_mfcdma64(atomic_buf, eah, eal, 128, 0, MFC_GETLLAR_CMD);
        spu_readch(MFC_RdAtomicStat);
        if (atomic_buf[0]) {
            /* ɤ᤿ͤ󥼥ä顤0᤹Ȥĩ
               ȥߥå˽᤻Ԥ¾븢򤨤 */
            atomic_buf[0] = 0;
            spu_mfcdma64(atomic_buf, eah, eal, 128, 0, MFC_PUTLLC_CMD);
            if (!(spu_readch(MFC_RdAtomicStat) & MFC_PUTLLC_STATUS))
                /* 롼פȴ */
                break;
        } else {
            /* ɤ᤿ͤä顤¾ï¾ */
            /* ꥶ١ü٥Ȥȯޤǥȡ뤷Ԥ */
            spu_readch(SPU_RdEventStat);
            /* ٥Ȥ򸡽ФΥåƤ */
            spu_writech(SPU_WrEventAck, MFC_LLR_LOST_EVENT);
        }   
    } while (1);
}


/* åؿ */
void
mutex_unlock()
{
    /* δؿϥåˤƤǤϤʤ */
    /* putlluc̵1ᤷĤġ¾SPEΥꥶ١ä */
    atomic_buf[0] = 1;
    spu_mfcdma64(atomic_buf, eah, eal, 128, 0, MFC_PUTLLUC_CMD);
    spu_readch(MFC_RdAtomicStat);
}

#define TAGID 3

int
main(unsigned long long spe, unsigned long long argp, unsigned long long envp)
{
    unsigned d;
    unsigned test_eal, test_eah;
    int i;

    eal = spu_readch(SPU_RdInMbox);
    eah = spu_readch(SPU_RdInMbox);

    test_eal = spu_readch(SPU_RdInMbox);
    test_eah = spu_readch(SPU_RdInMbox);

    spu_writech(MFC_WrTagMask, 1 << TAGID); 

    /* ٥ȤȤƥꥶ١ξüΤߤ򸫤褦˥٥ȥޥ */
    spu_writech(SPU_WrEventMask, MFC_LLR_LOST_EVENT);

    /* եȥ।٥к */
    while (spu_readchcnt(SPU_RdEventStat) > 0) {
        d = spu_readch(SPU_RdEventStat);
        spu_writech(SPU_WrEventAck, d);
    }

    for (i = 0; i < 1000000; i++) {

        /* å */
        mutex_lock();

        /* Ʊ˹⡹1ĤSPE¹ԤǤʤ */

        /* ¾ݾڤƤΤǡͭѿ̤ɤ߽Ф
           ƽ᤹ */
        spu_mfcdma64(test_buf, test_eah, test_eal, 128, TAGID, MFC_GET_CMD);
        spu_mfcstat(MFC_TAG_UPDATE_ALL);

        test_buf[0]++;

        spu_mfcdma64(test_buf, test_eah, test_eal, 128, TAGID, MFC_PUT_CMD);
#if 1
        spu_mfcstat(MFC_TAG_UPDATE_ALL);

        /* å */
        mutex_unlock();
#else
        /* üС */
        /* mutex_unlockƤˡͭѿνᤷ³
           putqlluc򥳥ޥɥ塼뤳ȤǥåβԤ */
        atomic_buf[0] = 1;
        spu_mfcdma64(atomic_buf, eah, eal, 128, TAGID, MFC_PUTQLLUC_CMD);

        spu_mfcstat(MFC_TAG_UPDATE_ALL);
#endif

    }

    return 0;
}
